/* JAVA CLASS IMPLEMENTAION FILE {{{ ______ vim:textwidth=79:foldmethod=marker
            
 *            project : VectorRace
 *               file : ScaleModelToDisplay.java
 *             author : Jakob Schmid
 *          commenced : 2005-03-16
 *       last changes : 2005-03-16
 *              notes :
 *         references : 
    __________________________________________________________________________
 */

package util;

// IMPORT ====================================================================
import java.awt.Graphics;
import java.lang.Math.*;
import model.Vector;
import java.awt.Rectangle;
// }}}


public class ScaleModelToDisplay {

    private static final int BORDER = 20;
    private static double scale = 0.1;
    public  static Vector topRight, bottomLeft;
    
    public static int scaleX(int x, Graphics g) {
        int dw = g.getClipBounds(new Rectangle()).width;
        int dx = (int) Math.round((x - bottomLeft.x) * getScale(g) 
		        + (dw / 2. - (topRight.x - bottomLeft.x) 
                        * getScale(g) / 2. ));
	return dx;
    }
    
    public static int scaleY(int y, Graphics g) {
        int dh = g.getClipBounds(new Rectangle()).height;
        int dy = (int) Math.round((y - bottomLeft.y) * getScale(g) 
                        + (dh / 2. - (topRight.y - bottomLeft.y) 
                        * getScale(g) / 2. ));
	return dh - dy; // java coordinates are vertically reversed
    }

    public static int getScale(Graphics g) {
        int dw = g.getClipBounds(new Rectangle()).width;
        int dh = g.getClipBounds(new Rectangle()).height;
	return Math.min( ( dw - BORDER * 2 ) / ( topRight.x - bottomLeft.x ),
                         ( dh - BORDER * 2 ) / ( topRight.y - bottomLeft.y ) );
    }
}
