package util;

import model.*;
import java.awt.geom.Point2D;
import gui.PointSet;
import java.util.ArrayList;

public class ConvertTrack {
    
    

    public ConvertTrack(PointSet track) {
	this.bottomLeft          = convertToBottomLeft(track);
        this.topRight            = convertToTopRight(track);
        this.contour             = convertToContour(track);
        this.legalStartingPoints = convertToLegalStartingPoints(track);
        this.goalLine            = convertToGoalLine(track);
        this.crossingDirection   = convertToCrossingDirection(track);
    }

    private Vector convertToBottomLeft(PointSet track) {
	Point2D[] outer = track.getOuter();
	double mx, my;
	mx = outer[0].getX();
	my = outer[0].getY();
	for (int i = 1; i < outer.length; i++) {
		if (outer[i].getX() < mx) mx = outer[i].getX();
		if (outer[i].getY() < my) my = outer[i].getY();
	}
	return new Vector((int)mx, (int)my);
    }

    private Vector convertToTopRight(PointSet track) {
        Point2D[] outer = track.getOuter();
        double mx, my;    
        mx = outer[0].getX();
        my = outer[0].getY();
        for (int i = 1; i < outer.length; i++) {
                if (outer[i].getX() > mx) mx = outer[i].getX();
                if (outer[i].getY() > my) my = outer[i].getY();
        }
        return new Vector((int)mx, (int)my);
    }

    private ArrayList convertToContour(PointSet track) {
	ArrayList contour = new ArrayList();
	Point2D[] outer = track.getOuter();
	java.util.Vector inner = track.getInner();

	Vector vx, vy;
	for (int i = 0; i < outer.length - 1; i++) {
		vx = new Vector((int)outer[i].getX(), (int)outer[i].getY());
		vy = new Vector((int)outer[i].getX(), (int)outer[i].getY(), (int)outer[i+1].getX(), (int)outer[i+1].getY());
		contour.add(new LineSegment(vx,vy));
	}
        vx = new Vector((int)outer[outer.length - 1].getX(), (int)outer[outer.length - 1].getY());
        vy = new Vector((int)outer[outer.length - 1].getX(), (int)outer[outer.length - 1].getY(), (int)outer[0].getX(), (int)outer[0].getY());
	contour.add(new LineSegment());

	for (int n = 0; n < inner.size(); n++) {
		Point2D[] innerset = (Point2D[])inner.get(n);
		for (int i = 0; i < innerset.length; i++) {
			vx = new Vector((int)outer[i].getX(), (int)outer[i].getY());
	                vy = new Vector((int)outer[i].getX(), (int)outer[i].getY(), (int)outer[i+1].getX(), (int)outer[i+1].getY());
        	        contour.add(new LineSegment(vx,vy));
		}
		vx = new Vector((int)outer[outer.length - 1].getX(), (int)outer[outer.length - 1].getY());
	        vy = new Vector((int)outer[outer.length - 1].getX(), (int)outer[outer.length - 1].getY(), (int)outer[0].getX(), (int)outer[0].getY());    
       	 	contour.add(new LineSegment());
	}

	return contour;
    }

    private ArrayList convertToLegalStartingPoints(PointSet track) {
	int[] startX = track.getStartX();
	int[] startY = track.getStartY();
	ArrayList lsp = new ArrayList();
	for (int i = 0; i < startX.length; i++) {
	    lsp.add(new Vector(startX[i],startY[i]));
	}
	return lsp;
    }

    private LineSegment convertToGoalLine(PointSet track) {
	double[] coor = new double[4];
	track.getWP()[track.getWP().length-1].getCoords(coor);
	return new LineSegment(new Vector((int)coor[0],(int)coor[1]), 
			       new Vector((int)coor[0],(int)coor[1],(int)coor[2],(int)coor[3]));
    }

    private Vector convertToCrossingDirection(PointSet track) {
 	return new Vector();
    }
}