/* JAVA CLASS IMPLEMENTAION FILE {{{ ______ vim:textwidth=79:foldmethod=marker
            
 *            project : VectorRace
 *               file : SquareTrack.java
 *             author : Jakob Schmid
 *          commenced : 2005-03-04
 *       last changes : 2005-03-04
 *              notes :
 *         references : 
    __________________________________________________________________________
 */

package tracks;

// IMPORT ====================================================================
import java.util.ArrayList;
import junit.framework.*;
import model.*;
// }}}

/**
 * Class description goes here.
 *
 * @author      d403b/c
 */
public class SquareTrack {

    public static Track createTrack() {
        Track track;

        // A simple square track
        ArrayList contour = new ArrayList();
        contour.add(new LineSegment(new Vector(-2,-2), new Vector( 4, 0)));
        contour.add(new LineSegment(new Vector( 2,-2), new Vector( 0, 4)));
        contour.add(new LineSegment(new Vector( 2, 2), new Vector(-4, 0)));
        contour.add(new LineSegment(new Vector(-2, 2), new Vector( 0,-4)));
        contour.add(new LineSegment(new Vector(-5,-5), new Vector( 10,  0)));
        contour.add(new LineSegment(new Vector( 5,-5), new Vector(  0, 10)));
        contour.add(new LineSegment(new Vector( 5, 5), new Vector(-10,  0)));
        contour.add(new LineSegment(new Vector(-5, 5), new Vector(  0,-10)));

        // Goal in the top end of the track
        LineSegment goalLine = new LineSegment(
                                 new Vector(0,2), new Vector(0,3));
        Vector crossingDirection = new Vector(1,0);

        // Starting points on top of the goal line
        ArrayList legalStartingPoints = new ArrayList();
        legalStartingPoints.add(new Vector(0,3));
        legalStartingPoints.add(new Vector(0,4));

        track = new Track(new Vector(-6,-6), new Vector(6,6), contour,
            legalStartingPoints, goalLine, crossingDirection);

        return track;
    }
}
