/* JAVA CLASS IMPLEMENTAION FILE {{{ ______ vim:textwidth=79:foldmethod=marker
            
 *            project : VectorRace
 *               file : TestTrack.java
 *             author : Jakob Schmid
 *          commenced : 2005-03-02
 *       last changes : 2005-03-02
 *              notes :
 *         references : 
    __________________________________________________________________________
 */

package model.test;

// IMPORT ====================================================================
//import java.util.*;
import junit.framework.*;
import tracks.*;
import model.*;
// }}}

/**
 * Class description goes here.
 *
 * @author      d403b/c
 */
public class TestTrack extends TestCase {

    Track track;

    public static void main(String args[]) {
        junit.textui.TestRunner.run(TestTrack.class);
    }

    public void setUp() {
        track = SquareTrack.createTrack();
    }

    public void testWallCrash() {
        // crash into right wall
        Assert.assertTrue (track.crash(new LineSegment(
                        new Vector(4,4), new Vector(2,0))));
        // crash into top wall with insane speed
        Assert.assertTrue (track.crash(new LineSegment(
                        new Vector(-3,0), new Vector(0,8))));
        // crash into bottom-left corner
        Assert.assertTrue (track.crash(new LineSegment(
                        new Vector(-4,-4), new Vector(-1,-1))));
        // crash out of bounds (right side)
        Assert.assertTrue (track.crash(new LineSegment(
                        new Vector(6,0), new Vector(1,0))));
        // drive diagonally from top-left corner towards the middle
        Assert.assertFalse(track.crash(new LineSegment(
                        new Vector(-4,4), new Vector(1,-1))));
        // drive nicely down right lane
        Assert.assertFalse(track.crash(new LineSegment(
                        new Vector(3,3), new Vector(0,-3))));
    }

    public void testGoalCrash() {
        // back over goal line from start point
        //Assert.assertTrue (track.crash(new LineSegment(
                        //new Vector(0,4), new Vector(2,0))));
    }

    public void testPassGoalLine() {
        // pass over goal line (the right direction)
        Assert.assertTrue (track.passesGoalLine(new LineSegment(
                        new Vector(-2,3), new Vector(4,1))));
        // not far enough...
        Assert.assertFalse(track.passesGoalLine(new LineSegment(
                        new Vector(-2,3), new Vector(1,0))));
    }
}
