/* JAVA CLASS IMPLEMENTAION FILE {{{ ______ vim:textwidth=79:foldmethod=marker
            
 *            project : VectorRace
 *               file : TestLineSegment.java
 *             author : Jakob Schmid
 *          commenced : 2005-03-02
 *       last changes : 2005-03-02
 *              notes :
 *         references : 
    __________________________________________________________________________
 */

package model.test;

// IMPORT ====================================================================
import junit.framework.*;
import model.*;
// }}}

/**
 * Class description goes here.
 *
 * @author      d403b/c
 */
public class TestLineSegment extends TestCase {
    public static void main(String args[]) {
        junit.textui.TestRunner.run(TestLineSegment.class);
    }

    public void setUp() {
    }

    public void testIntersection() {
        LineSegment ls1, ls2, ls3, ls4;

        // these should intersect
        ls1 = new LineSegment(new Vector(0, 0), new Vector(1, 4));
        ls2 = new LineSegment(new Vector(-1, 3), new Vector(2, -2));

        // and this one doesn't intersect with ls1 and ls2
        ls3 = new LineSegment(new Vector(-2, -2), new Vector(10, 0));

        // but this one intersects with ls3 only
        ls4 = new LineSegment(new Vector(8, 0), new Vector(-4, -4));

        Assert.assertTrue(ls1.intersectsWith(ls2));
        Assert.assertTrue(ls3.intersectsWith(ls3));
        Assert.assertTrue(ls4.intersectsWith(ls3));
        Assert.assertFalse(ls1.intersectsWith(ls3));
        Assert.assertFalse(ls2.intersectsWith(ls3));
    }

    public void testLegalCrossing() {
        LineSegment goal, lc, ic, nc;

        // this is a vertical goal line
        goal = new LineSegment(new Vector(0, 10), new Vector(0, -10));
        // we'd like the racer to cross from left to right
        Vector cd = new Vector(1, 0);
        // this is a legal crossing
        lc = new LineSegment(new Vector(-4, 2), new Vector(7, -3));
        // this is an illegal crossing
        ic = new LineSegment(new Vector(5, 0), new Vector(-10, 0));
        // this is not a crossing at all
        nc = new LineSegment(new Vector(2, 2), new Vector(0, 10));

        Assert.assertTrue(lc.legalCrossing(goal, cd));
        Assert.assertFalse(ic.legalCrossing(goal, cd));
        Assert.assertFalse(nc.legalCrossing(goal, cd));
    }
}
