/* JAVA CLASS IMPLEMENTAION FILE {{{ ______ vim:textwidth=79:foldmethod=marker
            
 *            project : VectorRace
 *               file : Vector.java
 *             author : Jakob Schmid
 *          commenced : 2005-03-02
 *       last changes : 2005-03-02
 *              notes :
 *         references : 
    __________________________________________________________________________
 */

package model;

// IMPORT ====================================================================


// }}}

/**
 * Class description goes here.
 *
 * @author      d403b/c
 */
public class Vector {
    public int x, y;

    public Vector() {x = 0; y = 0; }

    public Vector(int x, int y) { this.x = x; this.y = y; }

    public Vector(int x, int y, int dx, int dy) {
	this.x = x - dx;
	this.y = y - dy;
    }

    public Vector add(Vector other) {
        return new Vector(x + other.x, y + other.y);
    }

    public int dotProduct(Vector other) {
        return x * other.x + y * other.y;
    }

    public String toString() { 
	String res = "(";
	if(x>=0) res += " ";
	res += x + ",";
	if(y>=0) res += " ";
	res += y + ")";
	return res;
    }

    public boolean equals(Vector other) { return x == other.x && y == other.y; }

    public void draw(java.awt.Graphics g) {
	g.setColor(java.awt.Color.green);
	g.fillOval(util.ScaleModelToDisplay.scaleX(x,g) -3,
		   util.ScaleModelToDisplay.scaleY(y,g) -3, 7, 7);
    }
}
