/* JAVA CLASS IMPLEMENTAION FILE {{{ ________ vim:textwidth=79:foldmethod=marker
            
 *            project : VectorRace
 *               file : LineSegment.java
 *             author : Jakob Schmid
 *          commenced : 2005-03-02
 *       last changes : 2005-03-02
 *              notes :
 *         references : 
    ___________________________________________________________________________
 */

package model;

// IMPORT =====================================================================

// }}}

/**
 * Class description goes here.
 *
 * @author      d403b/c
 */
public class LineSegment {
    public Vector A, r;

    public LineSegment() {
        A = new Vector(0,0);
        r = new Vector(0,0);
    }

    public LineSegment(Vector A, Vector v) {
        this.A = A;
        this.r = v;
    }

    public boolean overlap(int A, int r, int otherA, int otherR) {
	return otherA >= A && A >= otherA + otherR 
	    || A >= otherA && otherA + otherR >= A 
	    || otherA >= A + r && A + r >= otherA + otherR 
	    || A + r >= otherA && otherA + otherR >= A + r;
    }
    
    public boolean intersectsWith(LineSegment other) {
	int oAx = other.A.x;
	int oAy = other.A.y;
	int orx = other.r.x;
	int ory = other.r.y; 
	// calculate determinant
	int determinant = (r.x * -ory) - (r.y * -orx);
	// if the determinant is 0, then the lines are parallel
	if(determinant == 0) {
	    // if they are equal, they may overlap, if they are long enough
	    if(r.y * (A.x - oAx) == (A.y - oAy) * r.x) {
		// we only need to look at overlap of one of the coordinates,
		// as the lines are on top of each other
		// if the lines are vertical, we have to investigate the
		// y-coordinate
		if(r.x == 0 && r.y != 0) {
		    if(overlap(A.y, oAy, r.y, ory))
			return true;
		}
		// otherwise, it is safe to investigate the x-coordinate
		else {
		    if(overlap(A.x, oAx, r.x, orx))
			return true;
		}
	    }
	}
	// they are not parallel, which must mean the LINES intersect, though
	// the line segments may not be long enough to intersect
	else {
	    // check for solutions
	    int t = ((oAx - A.x) * -ory - (oAy - A.y) * -orx);
	    int u = (r.x * (oAy - A.y) - r.y * (oAx - A.x));
	    // check that the solutions are inside the length of the line
	    // segment
	    if(Math.abs(determinant) >= Math.abs(t) && !(0 > t *  determinant) && Math.abs(determinant) >= Math.abs(u) && !(0 > u * determinant)) {
		return true;
	    }
	}
	return false;
    }

    public boolean legalCrossing(LineSegment goal, Vector cd) {
	return (r.x * cd.x + r.y * cd.y) > 0;
    }

    public boolean intersectsWith1(LineSegment other) {
        boolean intersection = false;

        // calculate determinant
        int determinant = r.x * -other.r.y - r.y * -other.r.x;

        // if the determinant is 0, then the lines are parallel
        if(determinant == 0) {
            // calculate slope of this line
            Slope thisSlope  = new Slope(r.y, r.x);

            // calculate slope of other line with respect to the starting
            // point of this line
            Slope slopeToOtherPoint = new Slope(A.y - other.A.y,
                                                      A.x - other.A.x );

            // if they are equal, they may overlap, if they are long enough
            if(thisSlope.equals(slopeToOtherPoint))
            {
                // we only need to look at overlap of one of the coordinates,
                // as the lines are on top of each other
                // if the lines are vertical, we have to investigate the
                // y-coordinate
                if(thisSlope.vertical()) {
                    if(overlap(A.y, other.A.y, r.y, other.r.y))
                            intersection = true;
                }
                // otherwise, it is safe to investigate the x-coordinate
                else {
                    if(overlap(A.x, other.A.x, r.x, other.r.x))
                            intersection = true;
                }
            }
        }
        // they are not parallel, which must mean the LINES intersect, though
        // the line segments may not be long enough to intersect
        else {
            // check for solutions
            double t = (   (other.A.x - A.x) * -other.r.y
			   - (other.A.y - A.y) * -other.r.x )
		 / (double) determinant;
            double u = (   r.x * (other.A.y - A.y)
			   - r.y * (other.A.x - A.x) )/ (double) determinant;

            // check that the solutions are inside the length of the line
            // segment
            if(t >= 0 && u >= 0 && t <= 1 && u <= 1) intersection = true;
	    //if(determinant >= t && !(0 > t *  determinant) && determinant >= u && !(0 > u * determinant)) intersection = true;
	}
        return intersection;
    }

    public boolean overlap1(int A, int otherA, int r, int otherR)
    {
        // overlap occurs if 
        //   this start/end-point is between the other start- and endpoint
          return A     <= otherA && A     >= otherA + otherR
              || A     >= otherA && A     <= otherA + otherR
              || A + r <= otherA && A + r >= otherA + otherR
              || A + r >= otherA && A + r <= otherA + otherR;
    }

    public boolean legalCrossing1(LineSegment goal, Vector cd) {
        boolean legal = false;

        // check if they intersect
        if(intersectsWith(goal)) {

            // check if it is the right direction
            if(r.dotProduct(cd) > 0) legal = true;
        }

        return legal;
    }

    public void draw(java.awt.Graphics g, java.awt.Color color) {
	g.setColor(color);
	g.drawLine(util.ScaleModelToDisplay.scaleX(A.x,g),
		   util.ScaleModelToDisplay.scaleY(A.y,g),
		   util.ScaleModelToDisplay.scaleX(A.x + r.x,g),
		   util.ScaleModelToDisplay.scaleY(A.y + r.y,g));
    }
    
    public void draw(java.awt.Graphics g) {
	draw(g, java.awt.Color.black);
    }
}
