/*
 * Created on Nov 11, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package gui;

import javax.swing.*;
import java.awt.event.*;
import java.util.Vector;
//import java.awt.*;
/**
 * @author illum
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class VectorRace extends JFrame {
	private JPanel leftSide, rightSide;
	private Game game;

	public VectorRace() {
		super("Vector Race");
		setDefaultLookAndFeelDecorated(true);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setSize(900,700);
		initGame(MapFactory.MAP_SIMPLE);
		initSplit();
		setJMenuBar(createMenu());
		setVisible(true);
	}
	private void initGame(int mapId){
		game = new Game(mapId);
		rightSide = new GameView(game);
		//rightSide.setSize(1024,1024);
		leftSide = new PlayerView(game);
	}
	private void initGame(){
		game = new Game();
		rightSide = new GameView(game);
		//rightSide.setSize(1024,1024);
		leftSide = new PlayerView(game);
	}
	
	private void initSplit(){
		JScrollPane tmpLeft = new JScrollPane();
		int incr = 10;
		tmpLeft.getHorizontalScrollBar().setUnitIncrement(incr);
		tmpLeft.getVerticalScrollBar().setUnitIncrement(incr);
		JScrollPane tmpRight = new JScrollPane();
		tmpRight.getHorizontalScrollBar().setUnitIncrement(incr);
		tmpRight.getVerticalScrollBar().setUnitIncrement(incr);
		tmpLeft.getViewport().add(leftSide);
		tmpRight.getViewport().add(rightSide);
		JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,tmpLeft,tmpRight);
		splitPane.setDividerLocation(150 + splitPane.getInsets().left);
		//splitPane.setOneTouchExpandable(true);
		splitPane.setDividerSize(3);
		getContentPane().add(splitPane);
	}
	private JMenuBar createMenu(){
		JMenuBar bar = new JMenuBar();

		JMenu file = new JMenu("File");
		file.setMnemonic(KeyEvent.VK_F);
		JMenuItem newGame = new JMenuItem(new NewGameAction(game));
		newGame.setMnemonic(KeyEvent.VK_N);
		file.add(newGame);
		JMenuItem exit = new JMenuItem(new ExitAction());
		exit.setMnemonic(KeyEvent.VK_X);
		file.add(exit);

		JMenu opt = new JMenu("Options");
		opt.setMnemonic(KeyEvent.VK_O);
		Vector gameOptions = game.getOptions();
		for (int i = 0;i < gameOptions.size();i++){
			opt.add((JComponent)gameOptions.elementAt(i));
		}

			
		bar.add(file);
		bar.add(opt);
		return bar;
	}
	
        public Game getGame() {
            return game;
        }
        
	public static void main(String[] args) {
		VectorRace vr = new VectorRace();
	}
}
