/*
 * Created on Nov 24, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package gui;

import java.util.Vector;
/**
 * @author illum
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class State {
	protected PositionVector vec = null;
	protected Vector properties = new Vector();
	protected int quarantine = 0;
	protected boolean crash = false;
	protected boolean goal = false;
	protected int cw = 0, cwc = 0;//Current wapoint and Current Waypoint Counter
	
	public State(PositionVector vec){
		this.vec = vec;
	}
	public State(int x, int y, int vx, int vy){
		this.vec = new PositionVector(x,y,vx,vy);
		
	}	
	public State(){
		vec = new PositionVector();
	}
	
	public State(State s){
		this.vec = new PositionVector(s.getVector().x,s.getVector().y,s.getVector().vx,s.getVector().vy);
		this.properties = (Vector)s.getProperties().clone();
		this.crash = s.isCrash();
		this.quarantine = s.getQuarantine();
		this.goal = s.goal();
		this.cw = s.getCurrentWaypoint();
		this.cwc = s.getCurrentWaypointCounter();
	}
	
	public void setCurrentWaypoint(int nb){
		cw = nb;
	}
	public void addToWaypointCounter(int nb){
		//System.out.print(" v " + nb + " cwcb " + cwc);
		cwc += nb;
		//System.out.print(" cwca " + cwc);
	}
	public void resetWaypointCounter(){
		cwc = 0;
	}
	public int getCurrentWaypoint(){
		return cw;
	}
	public int getCurrentWaypointCounter(){
		return cwc;
	}
	public double getVelocity(){

	double velocity = (Math.sqrt(Math.pow(((double)this.vec.vx), 2) + Math.pow(((double)this.vec.vy),2)));
				return velocity;
	}
	public boolean goal(){
		return goal;
	}
	public void setGoal(){
		goal = true;
	}
	public void unsetGoal(){
		goal = false;
	}
	
	public boolean isCrash(){
		return crash;
	}
	public void setCrash(){
		crash = true;
	}
	public void unsetCrash(){
		crash = false;
	}
	public boolean hasProperty(StateProperty prop){
		return properties.contains(prop);
	}
	public void addProperty(StateProperty prop){
		properties.add(prop);
	}
	public StateProperty getProperty(int i){
		return (StateProperty) properties.elementAt(i);
	}
	public Vector getProperties(){
		return properties;
	}
	
	public void decrementQuarantine(){
		if (quarantine > 0)
			quarantine--;
	}
	public void addQuarantine(int n){
		quarantine += n;
	}
	public int getQuarantine(){
		return quarantine;
	}
	public boolean quarantined(){
		return (quarantine > 0);
	}
	public PositionVector getVector(){
		return vec;
	}
	public void setVector(PositionVector vec){
		this.vec = vec;
	}
	public String toString(){
		return "State: x = " + vec.x + "  y: " + vec.y + " vx: " + vec.vx + " vy: " + vec.vy + " quar? " + quarantined() + " crash? " + crash + " cw: " + cw + " cwc: " + cwc;
	}
}
