
package gui;

import java.awt.*;
import javax.swing.*;

/* *
 * Created on 2004-11-29
 *
 */

/**
 * @author alsted
 *
 */
public class PlayerPanel extends JPanel{
	JLabel playerPL = new JLabel();
	JTextField playerName = new JTextField();
	
	JLabel playerVelocity = new JLabel();
	JTextField playerVel  = new JTextField();
	
	JLabel crashTurns = new JLabel();
	JTextField crashT  = new JTextField();
	
	JLabel numTurns = new JLabel();
	JTextField numT  = new JTextField();
	
	JLabel timeL = new JLabel();
	JProgressBar timeLeft = new JProgressBar();
	
	JLabel wayPointB = new JLabel();
	JProgressBar wayPointBar = new JProgressBar();
	
	public PlayerPanel(Player player){
		this.setBorder(BorderFactory.createLineBorder(player.getColor(),2));
		
		//this.setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));
		
		//this.setPreferredSize(new Dimension(300,300));
		//this.setMaximumSize(new Dimension(220,100));
		this.setMaximumSize(new Dimension(220,100));
		
		Dimension fieldDim = new Dimension(110,15);
		
		playerName.setPreferredSize(fieldDim);
		playerName.setMaximumSize(fieldDim);
		
		playerVel.setPreferredSize(fieldDim);
		playerVel.setMaximumSize(fieldDim);
		playerVel.setEditable(false);
		
		
		crashT.setPreferredSize(fieldDim);
		crashT.setMaximumSize(fieldDim);
		crashT.setEditable(false);
		
		
		numT.setPreferredSize(fieldDim);
		numT.setMaximumSize(fieldDim);
		numT.setEditable(false);
		
		timeLeft.setPreferredSize(fieldDim);
		timeLeft.setMaximumSize(new Dimension(fieldDim));
		
		wayPointBar.setPreferredSize(fieldDim);
		wayPointBar.setMaximumSize(new Dimension(fieldDim));
		
		GridBagLayout gbl = new GridBagLayout();
 		this.setLayout(gbl);
		GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.NONE;
		c.anchor = GridBagConstraints.WEST;
		
		c.weightx = 0.5;
		c.gridx = 0;
		c.gridy = 0;
		gbl.setConstraints(playerPL, c);
		this.add(playerPL);
		
		c.gridx = 1;
		c.gridy = 0;
		gbl.setConstraints(playerName, c);
		this.add(playerName);
		
		c.gridx = 0;
		c.gridy = 1;
		gbl.setConstraints(playerVelocity, c);
		this.add(playerVelocity);
		
		c.gridx = 1;
		c.gridy = 1;
		gbl.setConstraints(playerVel, c);
		this.add(playerVel);
		
		c.gridx = 0;
		c.gridy = 2;
		gbl.setConstraints(crashTurns, c);
		this.add(crashTurns);
		

		c.gridx = 1;
		c.gridy = 2;
		gbl.setConstraints(crashT, c);
		this.add(crashT);
		
		c.gridx = 0;
		c.gridy = 3;
		gbl.setConstraints(numTurns, c);
		this.add(numTurns);
		
		c.gridx = 1;
		c.gridy = 3;
		gbl.setConstraints(numT, c);
		this.add(numT);
		
		c.gridx = 0;
		c.gridy = 4;
		gbl.setConstraints(timeL, c);
		this.add(timeL);
		
		c.gridwidth=2;
		c.gridx = 1;
		c.gridy = 4;
		gbl.setConstraints(timeLeft, c);
		this.add(timeLeft);	
	
		c.gridx = 0;
		c.gridy = 5;
		gbl.setConstraints(wayPointB, c);
		this.add(wayPointB);
		
		c.gridwidth=2;
		c.gridx = 1;
		c.gridy = 5;
		gbl.setConstraints(wayPointBar, c);
		this.add(wayPointBar);
		
		this.updateDataToPanels(player);
	} 
	public void updateDataToPanels(Player player){
		playerPL.setText("Player:");
		playerName.setText(player.getPlayerName());
		
		playerVelocity.setText("Velocity (x,y):");
		//playerVel.setText(""+ player.getCurrentState().getVelocity());
		playerVel.setText(player.getCurrentState().getVector().vx +","+player.getCurrentState().getVector().vy);
		crashTurns.setText("Crash State:");
		crashT.setText(""+player.getCurrentState().getQuarantine());
		
		numTurns.setText("Moves:");
		numT.setText(""+ (player.getNumberMoves()-1));
		
		timeL.setText("Time Left:");
		wayPointB.setText("WP's to go:");
		
	} 
	public void updateWPBar(int wp, int max){
		wayPointBar.setMaximum(max);
		//System.out.println("wp, max:" + wp +","+ max);
		wayPointBar.setStringPainted(true);
		if(wp != max){
			wayPointBar.setString(wp + "/" +max);
		}else{
			wayPointBar.setString("Go for Goal!");
		}
		wayPointBar.setValue(wp);
		
	}
	public void updateTimeBar(int t, int max){
		timeLeft.setMaximum(max);
		int tmpTimeLeft = max - t;
		timeLeft.setStringPainted(true); 
		timeLeft.setString("" + tmpTimeLeft);
		timeLeft.setValue(t);
	}
}
