/*
 * Created on Nov 24, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package gui;

import java.awt.*;
import java.awt.geom.*;
import java.util.*;
/**
 * @author illum
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class Player extends Thread {
    protected GeneralPath history = null;
    private Area arrowHistory = null;
    private Color col = null;
    protected Stack stateStack = null;
    protected State currState = null;
    private String playerName = "Default Name";
    protected boolean computer = false;
    
    public Player(int x, int y,String pName){
        this(Color.white,x,y, pName);
    }
    
    public Player(Color col, int x, int y,String pName){
        this.col = col;
        this.playerName = pName;
        init(x,y);
    }
    
    private void init(int x, int y){
        stateStack = new Stack();
        addState(new State(x,y,0,0));
        history = new GeneralPath();
        history.moveTo((float)x, (float)y);
        arrowHistory = new Area();
        //arrowHistory.add(new Area(Game.getArrow(x,y,x,y-Game.ARROWLENGTH,1.5*Game.ARROWLENGTH,Game.ARROWANGLE)));
    }

    public boolean isComputer() {
        return computer;
    }
    
    public void addPlayerName(String pName){
        playerName = pName;
    }
    public String getPlayerName(){
        return playerName;
    }
    public int getNumberMoves(){
        return stateStack.size();
    }
    public State getCurrentState(){
        State curr = (State)stateStack.peek();
        return curr;
    }
    
    public void addState(State state){
        stateStack.add(state);
        //history.lineTo((float)state.getVector().x, (float)state.getVector().y);
        currState = state;
    }
    
    public GeneralPath getHistory(){
        return history;
    }
    public Stack getStack() {
        return stateStack;
    }
    public State getState() {
        return currState;
    }
    public Area getArrowHistory(){
        return arrowHistory;
    }
    public void addStateFromTrans(State trans){
        arrowHistory.add(new Area(Game.getArrow(trans.getVector().x,trans.getVector().y,trans.getVector().x+trans.getVector().vx,trans.getVector().y+trans.getVector().vy,Game.ARROWLENGTH,Game.ARROWANGLE)));
        trans.getVector().x = trans.getVector().x + trans.getVector().vx;
        trans.getVector().y = trans.getVector().y + trans.getVector().vy;
        history.lineTo(trans.getVector().x,trans.getVector().y);
        if (trans.isCrash()){
            trans.getVector().vx = 0;
            trans.getVector().vy = 0;
        }
        if (trans.goal()){
            System.out.println("Reached the goal!!!");
        }
        //trans.unsetCrash();
        //currState = trans;
        addState(trans);
    }
    public Color getColor(){
        return col;
    }
    
    public Transition[] getSuccessors(){
        Transition[] succ = new Transition[9];
        //System.out.println(currState);
        if (currState.goal()){
            return null;
        }
        if (!currState.quarantined()){
            for (int i = 0; i < 9; i++){
                succ[i] = new Transition(currState,i);
            }
        } else {
            //System.out.println("Sucker is quarantined!! " + currState.getQuarantine());
            addState(new State(currState));
            currState.decrementQuarantine();
            succ = null;
        }
        return succ;
    }
}
