package gui;

import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;


/*
 * Created on 2004-12-02
 *
 */

/**
 * @author alsted
 *
 */
public class MapFactory {
	public static final int MAP_FLAN = 0;
	public static final int MAP_SIMPLE = 1;
	public static final int MAP_GHOST = 2;
	public static final int MAP_CATALUNYA = 3;
	public static final int MAP_FUNMAP = 4;
	public static final int MAP_COOKIE = 5;
	public static final int MAP_CISS = 6;
        public static final int MAP_SQUARE = 7;
        
	public static final int nKnowMaps = 8;
	public static Map[] maps = new Map[nKnowMaps];
	public static int MAP_IN_USE = -1;
	public static boolean initialized = false;
        public static boolean smooth = true;
	
	public static void generateMaps(){
		for(int i=0; i< nKnowMaps;i++){
			maps[i] = MapFactory.getMap(i); 
		}
	}
	
	public static String getMapName(int id){	
		return maps[id].getName();
	
	}
	
	public static Map getMap(int id){
		
		if(!initialized){
			initialized = true;
			generateMaps();
		}
		
		Map m = new Map(); 
		PointSet ps = null;
		switch(id){
		case MAP_FLAN: 
			ps = new PointSetFlan();
			MAP_IN_USE=MAP_FLAN;
			break;
		case MAP_SIMPLE: 
			ps = new PointSetSimple();
			MAP_IN_USE = MAP_SIMPLE;
			break;
		case MAP_GHOST:
			ps = new PointSetGhost();
			MAP_IN_USE=MAP_GHOST;
			break;
		case MAP_CATALUNYA:
			ps = new PointSetCatalunya();
			MAP_IN_USE = MAP_CATALUNYA;
			break;
		case MAP_FUNMAP:
			ps = new PointSetFunMap();
			MAP_IN_USE = MAP_FUNMAP;
			break;
		case MAP_COOKIE:
			ps = new PointSetCookieMonster();
			MAP_IN_USE = MAP_COOKIE;
			break;
		case MAP_CISS:
			ps = new PointSetCISS();
			MAP_IN_USE = MAP_CISS;
			break;
                case MAP_SQUARE:
			ps = new PointSetSquare();
			MAP_IN_USE = MAP_SQUARE;
			break;
		}
		m = makeMap(m,ps);
		return m;
	}
	
	public static Map makeMap(Map m, PointSet points){
		m.setCircuit(makeArea(points));
		m.setWaypoints(points.getWP());
		m.setStartX(points.getStartX());
		m.setStartY(points.getStartY());
		//System.out.println("map fr navnet: " + points.getName());
		m.setName(points.getName());
		return m;
	}
	private static Area makeArea(PointSet flan){
		Area result = new Area(makePath(flan.getOuter())); 
		for(int i=0; i < flan.getInner().size();i++){
			result.subtract(new Area(makePath((Point2D[])(flan.getInner().elementAt(i)))));
		}
		return result;
	}
	private static GeneralPath makePath(Point2D[] points){
		GeneralPath path = new GeneralPath();
		Point2D[] ppoints = points;
		//System.out.println(ppoints.length);
                double a;
                if (smooth) a = 0.75;
                else a = 1;
		int b,c;
		path.moveTo((float)(a*points[0].getX()+(1-a)*points[points.length-1].getX()),(float)(a*points[0].getY()+(1-a)*points[points.length-1].getY()));
		b = 0;c = 1;
		for (int v=1;v<=points.length;v++){
			path.quadTo((float)(points[b].getX()),(float)(points[b].getY()),(float)(a*points[b].getX()+(1-a)*points[c].getX()),(float)(a*points[b].getY()+(1-a)*points[c].getY()));
			path.lineTo((float)(a*points[c].getX()+(1-a)*points[b].getX()),(float)(a*points[c].getY()+(1-a)*points[b].getY()));
			b=(b+1)%points.length;c=(c+1)%points.length;
		}
		return path;
	}
}