/*
 * Created on Nov 23, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package gui;

import java.awt.*;
import java.awt.geom.*;
/**
 * @author illum
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class Map implements Obstacle{
	private Area circuit = null;
	private Area complement = null;
	private Waypoint[] waypoints = null;
	private String name;
	private int[] startX;
	private int[] startY;
	
	public Map(){
		
	}
	public Map(Area circuit){
		this.circuit = circuit;
		computeComplement();
	}
	public void setStartX(int[] x){
		this.startX=x;
	}

	public String getName(){
		return name;
	}
	public void setName(String n){
		this.name = n;	
	}
	public void setStartY(int[] y){
		this.startY=y;
	}
	
	public int[] getStartX(){
		return this.startX;
	}

	public int[] getStartY(){
		return this.startY;
	}
	private void computeComplement(){
		int x = (int)Math.floor(circuit.getBounds2D().getX());
		int y = (int)Math.floor(circuit.getBounds2D().getY());
		int h = (int)Math.ceil(circuit.getBounds2D().getHeight());
		int w = (int)Math.ceil(circuit.getBounds2D().getWidth());
		complement = new Area(new Rectangle2D.Double(x-1,y-1,w+2,h+2));
		//System.out.println(complement.contains(new Point2D.Double(25,52)));
		//System.out.println(circuit.contains(new Point2D.Double(25,52)));
		complement.subtract(new Area(circuit));
		Area tmp = new Area(complement);
		tmp.intersect(circuit);
		//Point2D faf = new Point2D.Double(28,10);
		//System.out.println(tmp.isEmpty() + " x=" + faf.getX() + ", y=" + faf.getY() + " in circuit? " + circuit.contains(faf) + " in complement? " + complement.contains(faf));
	}
	
	public void setCircuit(Area circuit){
		this.circuit = circuit;
		computeComplement();
	}
	
	public Shape getCircuit(){
		return circuit;
	}
	public Shape getComplement(){
		return complement;
	}
	public void setWaypoints(Waypoint[] wps){
		this.waypoints = wps;
	}
	public Waypoint[] getWaypoints(){
		return waypoints;
	}
	public Transition processTransition(Transition trans, boolean crash){
		/*
		 *  Reserved space for throwing through processTranstion() for each obstacle
		 */
		for (int i = 0; i < trans.getActual().size();i++){
			State move = (State) trans.getActual().elementAt(i);
			double x1 = move.getVector().x;
			double y1 = move.getVector().y;
			double x2 = x1+move.getVector().vx;
			double y2 = y1+move.getVector().vy;
			double vx = move.getVector().vx;
			double vy = move.getVector().vy;
			GeneralPath pat = new GeneralPath(GeneralPath.WIND_EVEN_ODD);
			boolean first = true;
			PathIterator it = Game.getArrow(x1,y1,x2,y2,Game.GRAN,Game.EXTENTANGLE).getPathIterator(null);
			double[] coor = new double[2];
			while (!it.isDone()){
				it.currentSegment(coor);
				if (first){
					pat.moveTo((float)coor[0],(float)coor[1]);
					first = false;
				} else {
					pat.lineTo((float)coor[0],(float)coor[1]);
				}
				it.next();
			}
			it = Game.getArrow(x2,y2,x1,y1,Game.GRAN,Game.EXTENTANGLE).getPathIterator(null);
			while (!it.isDone()){
				it.currentSegment(coor);
				pat.lineTo((float)coor[0],(float)coor[1]);
				it.next();
			}
			pat.closePath();

			Area vec = new Area(pat);
			Area tmp = new Area(complement);
			tmp.intersect(new Area(pat));
			if (crash && !tmp.isEmpty()){//Move is crashing
				 double tx = x1,ty = y1;
				 double lineAngle = Math.atan2(y2-y1,x2-x1);
				 while (circuit.contains(tx,ty) && Math.sqrt(Math.pow(tx-x1,2) + Math.pow(ty-y1,2)) < Math.sqrt(Math.pow(vx,2)+Math.pow(vy,2))){
					tx = Math.cos(lineAngle)*Game.step+tx;
					ty = Math.sin(lineAngle)*Game.step+ty;
					//System.out.println("Point - x: " + tx + " y: " + ty);
				 }
				 int sx = snapToGrid(tx), sy = snapToGrid(ty);
				move.addQuarantine((int)Math.ceil(Math.sqrt(Math.pow(move.getVector().vx,2)+Math.pow(move.getVector().vy,2))/Game.qInc) );
				move.getVector().vx = sx-move.getVector().x;
				move.getVector().vy = sy-move.getVector().y;
				move.setCrash();
			}
			int cw = move.getCurrentWaypoint();
			//System.out.print(" b " + move.getCurrentWaypointCounter());
			move.addToWaypointCounter(waypoints[cw].requirementMet(move));
			//System.out.print(" a " + move.getCurrentWaypointCounter());
			if (move.getCurrentWaypointCounter() == 1){
				if ((cw+1) == waypoints.length){//This was the goal!!!
					move.setGoal();
				} else {
					move.setCurrentWaypoint(cw+1);
				}
				move.resetWaypointCounter();
			}
		}
	 return trans;
	}
	
	private int snapToGrid(double val){
		int tmp = (int)Math.floor(val);
		return tmp + ((val-tmp)>0.5?1:0);
	}
}
