/*
 * Created on Nov 23, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package gui;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.util.Vector;
import javax.swing.*;
import javax.swing.Timer;
import computerplayer.*;
//import java.awt.event.*;
/**
 * @author illum
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class Game {
    
    public static final int EVENT_UPDATE = 0;
    public static final int EVENT_NEWGAME = 1;
    public static final int EVENT_TICK = 2;
    public static final int EVENT_TIMESUP = 3;
    public static final int EVENT_NEXTPLAYER = 4;
    public static final int EVENT_GAMESTOPPED = 5;
    public static final int EVENT_NEWMAP = 6;
    
    
    private final int OLDSCHOOL_GRID = 0;
    private final int OLDSCHOOL_HISTORY = 1;
    private final int OLDSCHOOL_ARROWS = 2;
    private final int OLDSCHOOL_TIMER = 3;
    private final int OLDSCHOOL_SMOOTH = 4;
    private final int OLDSCHOOL_CRASH = 5;
    
    Map map = null;
    Vector listeners = new Vector();
    private boolean gameStarted = false;
    private Vector players = null;
    private int nbPlayers = 2;
    private int[] positions = null;
    //private int positionCounter = 0;
    //Misc. parameters
    public static final int qCount = 1;
    public static final int qInc = 1000;
    public static final double step = 0.1;
    //Oldschool parameters
    private boolean showGrid = true;
    private boolean showHistory = true;
    private boolean showArrowHistory = true;
    private boolean useTimer = true;
    private boolean smooth = true;
    private boolean crash = true;
    
    public static final double GRAN = 0.001;
    public static final double ARROWLENGTH = 0.4;
    public static final double ARROWANGLE = 25;
    public static final double EXTENTANGLE = 5;
    
    private Color[] playerColors = {Color.blue, Color.green, Color.orange, Color.darkGray,Color.magenta, Color.lightGray};
    
    private int currPlayer = 0;
    public Transition[] currMoves = null;
    private int[] timeLimits = {15,30,45,60,90,120};
    private int timeLimit = timeLimits[0]; //Time limit per move in seconds
    private Timer timer;
    
    private int mapID;
    
    public Game(int mapId){
        mapID = mapId;
        map = MapFactory.getMap(mapId);
        timer = new Timer(1000, new TickHandler(this));
    }
    public Game(){
        mapID = 0;
        map = new Map();
        map.setCircuit(TestFlan.getStandard());
        map.setWaypoints(TestFlan.getStandardWaypoints());
        timer = new Timer(1000, new TickHandler(this));
    }
    
    public void setNumberPlayers(int nb){
        nbPlayers = nb;
    }
    public void setMoveTime(int t){
        timeLimit = t;
    }
    public int getMoveTime(){
        return timeLimit;
    }
    
    public void setPlayers(int nb){
        int n = (nb > maxPlayers()?maxPlayers():nb);
        players = new Vector();
        for (int i = 0; i < n; i++){
            players.add(new Player(playerColors[i], this.map.getStartX()[i], this.map.getStartY()[i], "Player " + i));
        }
    }
    
    public void setComputerPlayer(int n, ComputerPlayer cp) {
        Player tmpPlayer = (Player)players.get(n);
        cp.init(tmpPlayer,this);
        players.set(n, cp);
    }
    
    public boolean useTimer(){
        return useTimer;
    }
    public void setTimer(){
        useTimer = true;
    }
    public void unsetTimer(){
        useTimer = false;
    }
    public void setTimeLimit(int nb){ timeLimit = nb;}
    public int getTimeLimit(){ return timeLimit;}
    
    private void nextPlayer(){
        currMoves = null;
        timer.stop();
        while (currMoves == null){
            currPlayer = (currPlayer + 1)%nbPlayers;
            currMoves = getTransitions();
            if (gameFinished()){
                System.out.println("<------------------ GAME OVER ------------------>");
                stopGame();
                return;
            }
        }
        if (useTimer){
            timer.start();
        }
        //System.out.println("Flan" + ((Player) players.elementAt(currPlayer)).getCurrentState().toString());
        notifyListeners(EVENT_NEXTPLAYER);
        if (((Player)players.get(currPlayer)).isComputer()) {
            ((ComputerPlayer)players.get(currPlayer)).interrupt();
	    //selectMove(((ComputerPlayer)players.get(currPlayer)).nextMove());
        }
    }
    
    public void playerFinished(){
        int tmp = 0;
        while (positions[tmp] != -1 && positions[tmp] != currPlayer && tmp < nbPlayers){
            tmp++;
        }
        if (tmp < nbPlayers) {
            positions[tmp] = currPlayer;
        }
    }
    
    public int getCurrentPlayer(){
        return currPlayer;
    }
    public int maxPlayers(){
        return playerColors.length;
    }
    public int getNumberPlayers(){
        return nbPlayers;
    }
    public Player getPlayer(int n){
        return (Player)players.elementAt(n);
    }
    public Color getCurrentPlayerColor(){
        return getPlayerColor(currPlayer);
    }
    public Color getPlayerColor(int n){
        return playerColors[n];
    }
    public Transition[] getMoves(){
        return currMoves;
    }
    
    public void selectMove(int n){
        State trans = currMoves[n].getRandom();
        getPlayer(currPlayer).addStateFromTrans(trans);    
        nextPlayer();
    }
    
    public void selectDefaultMove(){
        int i = 0;
        while (currMoves[i] == null){
            i++;
        }
        selectMove(i);
    }
    
    private boolean positionOccupiedByPlayer(Transition trans,int p){
        //System.out.println("FAF1 " + ((Player) players.elementAt(p)).getCurrentState());
        boolean xMatch = ((trans.getState().getVector().x+trans.getState().getVector().vx) == getPlayer(p).getCurrentState().getVector().x);
        //System.out.println("FAF2 " + p);
        boolean yMatch = ((trans.getState().getVector().y+trans.getState().getVector().vy) == getPlayer(p).getCurrentState().getVector().y);
        //System.out.println("FAF1 " + p);
        return (xMatch && yMatch);
    }
    
    private Transition[] getTransitions(){
        if (getPlayer(currPlayer).getCurrentState().goal()){
            playerFinished();
        }
        
        Transition[] trans = getPlayer(currPlayer).getSuccessors();
        if (trans == null)
            return trans;
        for (int i = 0; i < trans.length; i++){
            for (int j = 0; j < nbPlayers; j++){
                if ((j != currPlayer) && positionOccupiedByPlayer(trans[i],j)){
                    trans[i] = null;
                    break;
                }
            }
            if (trans[i] != null){
                if (trans[i].getState().isCrash()){
                    if (map.getCircuit().contains(trans[i].getState().getVector().x+trans[i].getState().getVector().vx,trans[i].getState().getVector().y+trans[i].getState().getVector().vy)){
                        for (int j = 0; j < trans[i].getActual().size();j++){
                            ((State)trans[i].getActual().elementAt(j)).unsetCrash();
                        }
                        trans[i].getState().unsetCrash();
                    } else {
                        trans[i] = null;
                        continue;
                    }
                } else {
                    trans[i] = map.processTransition(trans[i],crash);
                }
            }
        }
        return trans;
    }
    public void timerInput(int e){
        switch(e){
            case EVENT_TICK: 	notifyListeners(e);break;
            case EVENT_TIMESUP: 	selectDefaultMove(); break;
        }
    }
    
    public void addChangeListener(ChangeListener l){
        listeners.add(l);
    }
    public void removeChangeListeners(ChangeListener l){
        listeners.removeElement(l);
    }
    private void notifyListeners(int event){
        for (int i = 0; i < listeners.size(); i++){
            ((ChangeListener) listeners.elementAt(i)).changed(event);
        }
    }
    public void setMap(int id){
        mapID = id;
        map = MapFactory.getMap(id);
        notifyListeners(Game.EVENT_NEWMAP);
        //		for (int i = 0; i < listeners.size();i++)
        //			System.out.println(listeners.elementAt(i).getClass());
    }
    public void setMap(Map m){
        map = m;
        notifyListeners(Game.EVENT_NEWMAP);
    }
    public Map getMap(){
        return map;
    }
    
    public boolean gameFinished(){
        if (positions == null){
            return false;
        }
        return (positions[nbPlayers-1] != -1);
    }
    public void resetPositions(){
        positions = null;
    }
    public void startGame(){
        //nbPlayers = 6;
        setPlayers(nbPlayers);
        currPlayer = (int) Math.floor(Math.random()*nbPlayers);
        currMoves = getTransitions();
        gameStarted = true;
        //positionCounter = 0;
        positions = new int[nbPlayers];
        for (int i = 0;i < nbPlayers;i++){
            positions[i] = -1;
        }
        notifyListeners(EVENT_NEWGAME);
        if (useTimer){
            timer.start();
        }
    }
    public boolean showGrid(){
        return showGrid;
    }
    public boolean showHistory(){
        return showHistory;
    }
    public boolean showArrowHistory(){
        return showArrowHistory;
    }
    public boolean smooth(){
        return smooth;
    }
    public boolean gameStarted(){
        return gameStarted;
    }
    public void stopGame(){
        gameStarted = false;
        notifyListeners(EVENT_GAMESTOPPED);
	//player.join();
    }
    public static GeneralPath getArrow(double x1, double y1, double x2, double y2, double length, double angle){
        double lineAngle = Math.atan2(y1-y2,x1-x2);
        GeneralPath arrow = new GeneralPath();
        arrow.moveTo((float) (x2+Math.cos(lineAngle-Math.toRadians(angle))*(length)), (float)(y2+Math.sin(lineAngle-Math.toRadians(angle))*(length)));
        arrow.lineTo((float)x2,(float)y2);
        arrow.lineTo((float) (x2+Math.cos(lineAngle+Math.toRadians(angle))*(length)), (float)(y2+Math.sin(lineAngle+Math.toRadians(angle))*(length)));
        arrow.closePath();
        return arrow;
    }
    
    
    public void switchParameter(int parameter){
        switch(parameter){
            case OLDSCHOOL_ARROWS: showArrowHistory = !showArrowHistory; break;
            case OLDSCHOOL_GRID: showGrid = !showGrid; break;
            case OLDSCHOOL_HISTORY: showHistory = !showHistory; break;
            case OLDSCHOOL_TIMER: useTimer = !useTimer; break;
            case OLDSCHOOL_SMOOTH:
                MapFactory.smooth = !MapFactory.smooth;
                MapFactory.initialized = false;
                MapFactory.generateMaps();
                map = MapFactory.getMap(mapID);
                break;
            case OLDSCHOOL_CRASH: crash = !crash; break;
        }
        notifyListeners(EVENT_UPDATE);
    }
    
    public Vector getOptions(){
        Vector options = new Vector();
        JMenu oldschool = new JMenu("Oldschool");
        oldschool.setMnemonic(KeyEvent.VK_O);
        JCheckBoxMenuItem tmp = new JCheckBoxMenuItem(new ParameterAction("Show Grid",this,OLDSCHOOL_GRID,KeyEvent.VK_G));
        tmp.setState(showGrid);
        oldschool.add(tmp);
        tmp = new JCheckBoxMenuItem(new ParameterAction("Show History",this,OLDSCHOOL_HISTORY,KeyEvent.VK_H));
        tmp.setState(showHistory);
        oldschool.add(tmp);
        tmp = new JCheckBoxMenuItem(new ParameterAction("Show Arrows",this,OLDSCHOOL_ARROWS,KeyEvent.VK_A));
        tmp.setState(showArrowHistory);
        oldschool.add(tmp);
        tmp = new JCheckBoxMenuItem(new ParameterAction("Use Timer",this,OLDSCHOOL_TIMER,KeyEvent.VK_T));
        tmp.setState(useTimer);
        oldschool.add(tmp);
        tmp = new JCheckBoxMenuItem(new ParameterAction("Smooth",this,OLDSCHOOL_SMOOTH,KeyEvent.VK_S));
        tmp.setState(smooth);
        oldschool.add(tmp);
        tmp = new JCheckBoxMenuItem(new ParameterAction("Crash",this,OLDSCHOOL_CRASH,KeyEvent.VK_C));
        tmp.setState(crash);
        oldschool.add(tmp);
        options.add(oldschool);
        
        JMenu nbPlayers = new JMenu("Number of Players");
        nbPlayers.setMnemonic(KeyEvent.VK_P);
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem rad;
        for (int i = 1; i <= maxPlayers(); i++){
            rad = new JRadioButtonMenuItem(new PlayerNumberAction(i,this));
            if (i == this.nbPlayers)
                rad.setSelected(true);
            group.add(rad);
            nbPlayers.add(rad);
        }
        options.add(nbPlayers);
        
        JMenu mTime = new JMenu("Move Time");
        mTime.setMnemonic(KeyEvent.VK_T);
        ButtonGroup timeGroup = new ButtonGroup();
        JRadioButtonMenuItem radTime;
        for (int j = 0; j < timeLimits.length; j++){
            radTime = new JRadioButtonMenuItem(new MoveTimeAction(this.timeLimits[j],this));
            if (timeLimits[j] == this.timeLimit){
                radTime.setSelected(true);
            }
            timeGroup.add(radTime);
            mTime.add(radTime);
        }
        options.add(mTime);
        
        JMenu mMaps = new JMenu("Maps");
        mMaps.setMnemonic(KeyEvent.VK_M);
        ButtonGroup mapGroup = new ButtonGroup();
        JRadioButtonMenuItem radMap;
        for (int j = 0; j < MapFactory.nKnowMaps; j++){
            radMap = new JRadioButtonMenuItem(new MapChangeAction(MapFactory.getMapName(j),j,this));
            //System.out.println("" + j + "in use er:" + MapFactory.MAP_IN_USE);
            if (j == MapFactory.MAP_IN_USE){
                radMap.setSelected(true);
            }
            mapGroup.add(radMap);
            mMaps.add(radMap);
        }
        options.add(mMaps);
        
        return options;
    }
    
}
