package display;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import model.*;
import tracks.*;
import algorithms.*;

public class Display extends JFrame 
    implements KeyListener, ComponentListener{
    
    int width = 800;
    int height = 600;

    Track track; 
    Path path;

    public Display(String str, Track track, Path path){
	super(str);
	this.track = track;
	this.path = path;
	this.setSize(width, height);
	addKeyListener(this);
	addComponentListener(this);
	util.ScaleModelToDisplay.bottomLeft = track.bottomLeft;
	util.ScaleModelToDisplay.topRight = track.topRight;
	getContentPane().setLayout(null);
	this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	this.setLocation(300,200);
	this.setVisible(true);
    }

    public void update(Graphics g){	
	paint(g);
    }

    public void paint(Graphics g){
	g.setColor(Color.red);
	for (int y = track.bottomLeft.y + 1; y < track.topRight.y; y++) {
	    for (int x = track.bottomLeft.x + 1; x < track.topRight.x; x++) {
		g.fillOval(util.ScaleModelToDisplay.scaleX(x,g) - 1,
			   util.ScaleModelToDisplay.scaleY(y,g) - 1,3,3);
	    }
	}
	track.draw(g);
	path.draw(g);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
	int numLockKeyPressed = e.getKeyCode()-96;
        System.out.println(numLockKeyPressed);
	repaint();
    }

    public void componentResized(ComponentEvent e) {
	repaint();
    }

    public void componentShown(ComponentEvent e) {
    }

    public  void componentHidden(ComponentEvent e) {}

    public void componentMoved(ComponentEvent e) {}

    public static void main(String[] args){
	Track track = MazeTrack.createTrack();
	BreadthFirstSearchPred bfs = new BreadthFirstSearchPred();
	//BreadthFirstSearch bfs = new BreadthFirstSearch();
	Path path = bfs.findPath(track);
	Display display = new Display("VectorRace", track, path);
    }
}
