/* JAVA CLASS IMPLEMENTAION FILE {{{ ______ vim:textwidth=79:foldmethod=marker
            
 *            project : VectorRace
 *               file : TrackAnalysis.java
 *             author : Andreas Madsen
 *          commenced : 2005-03-16
 *       last changes : 2005-03-16
 *              notes :
 *         references : 
    __________________________________________________________________________
 */

package analysis;

// IMPORT ====================================================================
import java.util.ArrayList;
import model.*;
import display.*;
import algorithms.*;
// }}}

/**
 * Class description goes here.
 *
 * @author      d403b/c
 */
public class TrackAnalysis {

    public void TrackAnalysis(PathFinder pf, boolean quiet) {
        boolean show = false;
	int repeat = 5;
	Vector bl = new Vector();
        Vector tr = new Vector();
        LineSegment goal;
	
	// Create track 28x32
	bl.x = bl.y = 0;
	tr.x = 28;
	tr.y = 32;
	
	// create Goal line
	goal = new LineSegment(new Vector(0,31),new Vector(4,0));

        // crossing direction: up
        Vector cd = new Vector();
        cd.x = 0; cd.y = 1;
	
        ArrayList lsp = new ArrayList();
	
	// only one starting point
	lsp.add(new Vector(27,1));
	
        // contours on the track
        ArrayList con = new ArrayList();
	for(int x = 4; x < tr.y; x += 4) {
	    int y = x % 8;
	    if (y == 0) {
		for(int z = 0; z < tr.y-4; z+=2) {
		    con.add(new LineSegment(new Vector(x,y + z), new Vector(0,2)));
		}
	    } else {
		for(int z = tr.y-4; z > 0; z-=2) {
		    con.add(new LineSegment(new Vector(x,y + z), new Vector(0,-2)));
		}
	    }
	}
	int t = 0;
	for(int x = 0; x < tr.x; x += 4) {
	    for(int y = 4; y < tr.y; y += 4) {
		if(t==0) t = 2; else t=0;
		con.add(new LineSegment(new Vector(x+t,y), new Vector(2,0)));
	    }
	}
	//Caption
        String caption = "Analysis of " + pf.getClass().getName() + " algorithm ";
        while(caption.length() < 79) caption += "=";
        if(!quiet) System.out.println(caption);

	while(!con.isEmpty()) {
	    long startTime,endTime,avgRunTime = 0;
	    long[] runTime = new long[repeat+1];
	   
	    Track track = new Track(bl, tr, con, lsp, goal, cd);
	    
	    // activate algorithm 
	    Path path = new Path();
	    for(int r = 0; r <= repeat; r++) {
		startTime = System.currentTimeMillis();
		path = pf.findPath(track);
		endTime = System.currentTimeMillis();
		runTime[r] = (endTime - startTime);
	    }
	    for(int r = 0; r < runTime.length; r++) {
		avgRunTime += runTime[r];
	    }
	    avgRunTime /= runTime.length;
           
	    if (show && con.size() == 12) {
		display.Display display;
		display = new display.Display("Test",track,path);
	    }
	    if(quiet) System.out.println(con.size() + " " + pf.getInfo().iterations + " " + avgRunTime);
	    con.remove(con.size()-1);
	}
    }

    public static void main(String[] args) {
	TrackAnalysis analysis = new TrackAnalysis();
	analysis.TrackAnalysis(new BreadthFirstSearchArrayHash(),true);
    }
}
