/* JAVA CLASS IMPLEMENTAION FILE {{{ ______ vim:textwidth=79:foldmethod=marker
            
 *            project : VectorRace
 *               file : TestMinimalBitArray.java
 *             author : Jakob Schmid
 *          commenced : 2005-04-08
 *       last changes : 2005-04-08
 *              notes :
 *         references : 
    __________________________________________________________________________
 */

package algorithms.containers.test;

// IMPORT ====================================================================
import model.*;
import java.util.ArrayList;
import junit.framework.*;
import algorithms.containers.*;
// }}}

/**
 * Class description goes here.
 *
 * @author      d403b/c
 */
public class TestMinimalBitArray extends TestCase {
    public MinimalBitArray mi3x1, mi5x3, miRandom;

    public static void main(String args[]) {
        junit.textui.TestRunner.run(TestMinimalBitArray.class);
    }

    public void setUp() {
        mi3x1 = new MinimalBitArray(new Track(
                    new Vector(-2,-1), new Vector(2,1),
                    new ArrayList(), new ArrayList(),
                    new LineSegment(new Vector(-2,0), new Vector(0,1)),
                    new Vector(1,0)));
        mi5x3 = new MinimalBitArray(new Track(
                    new Vector(-3,-2), new Vector(3,2),
                    new ArrayList(), new ArrayList(),
                    new LineSegment(new Vector(-3,0), new Vector(0,1)),
                    new Vector(1,0)));
        int width  = (int) Math.round(Math.random() * 30 + 1);
        int height = (int) Math.round(Math.random() * 30 + 1);
        miRandom = new MinimalBitArray(new Track(
                    new Vector(0,0), new Vector(width, height),
                    new ArrayList(), new ArrayList(),
                    new LineSegment(new Vector(-2,0), new Vector(0,1)),
                    new Vector(1,0)));
    }

    public void testMaxLeftVelocityAt() {
        Assert.assertTrue(mi5x3.maxLeftVelocityAt(0, 5) == 2);
        Assert.assertTrue(mi5x3.maxLeftVelocityAt(1, 5) == 2);
        Assert.assertTrue(mi5x3.maxLeftVelocityAt(2, 5) == 1);
        Assert.assertTrue(mi5x3.maxLeftVelocityAt(3, 5) == 1);
        Assert.assertTrue(mi5x3.maxLeftVelocityAt(4, 5) == 0);
    }

    public void testPossibleVelocity() {
        Assert.assertTrue(mi5x3.possibleVelocitiesAt(0) == 1);
        Assert.assertTrue(mi5x3.possibleVelocitiesAt(1) == 2);
        Assert.assertTrue(mi5x3.possibleVelocitiesAt(2) == 2);
        Assert.assertTrue(mi5x3.possibleVelocitiesAt(3) == 3);
        Assert.assertTrue(mi5x3.possibleVelocitiesAt(4) == 3);
    }

    public void testConfigurationCount() {
        Assert.assertTrue(mi3x1.configurationCountAt(0, 3) == 2);
        Assert.assertTrue(mi3x1.configurationCountAt(1, 3) == 3);
        Assert.assertTrue(mi3x1.configurationCountAt(2, 3) == 2);

        Assert.assertTrue(mi5x3.configurationCountAt(0, 5) == 3);
        Assert.assertTrue(mi5x3.configurationCountAt(1, 5) == 4);
        Assert.assertTrue(mi5x3.configurationCountAt(2, 5) == 3);
        Assert.assertTrue(mi5x3.configurationCountAt(3, 5) == 4);
        Assert.assertTrue(mi5x3.configurationCountAt(4, 5) == 3);

        Assert.assertTrue(mi5x3.configurationCountAt(0, 3) == 2);
        Assert.assertTrue(mi5x3.configurationCountAt(1, 3) == 3);
        Assert.assertTrue(mi5x3.configurationCountAt(2, 3) == 2);
    }

    public void testOffsets() {
        Assert.assertTrue(mi3x1.xOffset[0] == 1);
        Assert.assertTrue(mi3x1.xOffset[1] == 3);
        Assert.assertTrue(mi3x1.xOffset[2] == 5);

        Assert.assertTrue(mi5x3.xOffset[0] == 2);
        Assert.assertTrue(mi5x3.xOffset[1] == 5);
        Assert.assertTrue(mi5x3.xOffset[2] == 8);
        Assert.assertTrue(mi5x3.xOffset[3] == 11);
        Assert.assertTrue(mi5x3.xOffset[4] == 14);

        Assert.assertTrue(mi5x3.yOffset[0] == 1);
        Assert.assertTrue(mi5x3.yOffset[1] == 3);
        Assert.assertTrue(mi5x3.yOffset[2] == 5);
    }

    public void testAddAndMember() {
        Configuration c1 = new Configuration(new Vector(0,0), new Vector(-2,-1));
        Configuration c2 = new Configuration(new Vector(2,1), new Vector(1,-1));
        Configuration c3 = new Configuration(new Vector(-2,-1), new Vector(0,0));
        Configuration c4 = new Configuration(new Vector(0,0), new Vector(0,0));
        Configuration c5 = new Configuration(new Vector(1,1), new Vector(0,-1));
        mi5x3.add(c1);
        mi5x3.add(c2);
        mi5x3.add(c3);
        Assert.assertTrue(mi5x3.member(c1));
        Assert.assertTrue(mi5x3.member(c2));
        Assert.assertTrue(mi5x3.member(c3));
        Assert.assertFalse(mi5x3.member(c4));
        Assert.assertFalse(mi5x3.member(c5));
    }
}
