/* JAVA CLASS IMPLEMENTAION FILE {{{ ______ vim:textwidth=79:foldmethod=marker
            
 *            project : VectorRace
 *               file : MinimalBitArray.java
 *             author : Jakob Schmid
 *          commenced : 2005-04-10
 *       last changes : 2005-04-10
 *              notes :
 *         references : 
    __________________________________________________________________________
 */

package algorithms.containers;

import model.*;
import tracks.*;
import java.lang.Math;

// }}}

/**
 * Class description goes here.
 *
 * @author      d403b/c
 */
public class MinimalBitArray extends MinimalArray {

    public char[] array;
    private int horizontalCC; // horizontal configuration count

    public MinimalBitArray(Track track) {
        super(track);
        horizontalCC = configurationCountInOneDimension(width);
        // allocate enough chars (16 bits each) to hold ho.CC * cc1d(height)
        // bits
        array = new char[(horizontalCC 
                * configurationCountInOneDimension(height) + 15) / 16];
    }

    public void add(Configuration conf) {
        int x = xOffset[conf.a.x - (blx + 1)] + conf.v.x;
        int y = yOffset[conf.a.y - (bly + 1)] + conf.v.y;
        int bit = y * horizontalCC + x;
        // at the (bit/16)th char, set the (bit mod 16)th bit
        array[bit / 16] |= 1 << (bit % 16);
    }
    
    public boolean member(Configuration conf) {
        int x = xOffset[conf.a.x - (blx + 1)] + conf.v.x;
        int y = yOffset[conf.a.y - (bly + 1)] + conf.v.y;
        int bit = y * horizontalCC + x;
        // at the (bit/16)th char, check the (bit mod 16)th bit
        return (array[bit / 16] & (1 << (bit % 16))) != 0;
    }
}
