/* JAVA CLASS IMPLEMENTAION FILE {{{ ______ vim:textwidth=79:foldmethod=marker
            
 *            project : VectorRace
 *               file : BreadthFirstSearch.java
 *             author : Jakob Schmid
 *          commenced : 2005-03-04
 *       last changes : 2005-03-16
 *              notes :
 *         references : 
    __________________________________________________________________________
 */

package algorithms;

// IMPORT ====================================================================
import java.util.ArrayList;
import model.*;
import tracks.*;
import util.Move;
import algorithms.containers.*;
// }}}

/**
 * Class description goes here.
 *
 * @author      d403b/c
 */
public class BreadthFirstSearchArray implements PathFinder{

    private int iterations;

    public Path findPath(Track track)
    {
        iterations = 0;
        Queue Q = new Queue(); // configuration-path pairs to be inspected
        //Set   S = new Set();   // visited configurations
	ArraySet S = new ArraySet(track);

	//System.out.println("The Time for Array: " + 
			   //(System.currentTimeMillis() - starttime));

        Configuration conf = new Configuration(
                (Vector) track.legalStartingPoints.get(0), new Vector());
        Q.enQueue(new QueueElement(conf, new Path()));
        S.add(conf);
        while (!Q.isEmpty()) {
            iterations++;
	    //if (iterations % 5000 == 0) 
		//System.out.println("The QueueSize is " + Q.size() + 

            // configurations-path pair:
            QueueElement QE = (QueueElement) Q.deQueue();
            Vector A = QE.conf.a; // position
            Vector v = QE.conf.v; // velocity
            Path   P = QE.path;
            P.add(QE.conf);
            for(int i = 1; i <= 9; i++) {
                Vector ai = Move.acceleration(i);
                LineSegment lineseg = new LineSegment(A,v.add(ai));
                conf = new Configuration(A.add(v.add(ai)),v.add(ai),i);
                if (!track.crash(lineseg) && !S.member(conf)) {
                    // win
                    if (track.passesGoalLine(lineseg) 
                            && !track.startsFromLegalStartingPoint(lineseg)) {
			//System.out.println("The count in S: " + S.count);
                        P.add(conf);
                        return P;
                    } else {
                        Q.enQueue(new QueueElement(conf,P.duplicate()));
                        S.add(conf);
                    }
                }
            }
        }
	//System.out.println("The count in S: " + S.count);
        return null;
    }

    public PathFinderInfo getInfo() {
        PathFinderInfo info = new PathFinderInfo();
        info.iterations = iterations;
        return info;
    }
}
